package ru.yandex.travel.integration.balance.model.csv;

import javax.annotation.Nonnull;

/**
 * Статус платежного поручения.
 */
public enum BankOrderStatus {

    NEW("new"),
    /**
     * Платеж отменен.
     */
    CANCELLED("cancelled"),
    /**
     * Платеж был отправлен в банк, но обработка не начата.
     */
    STARTED("started"),
    /**
     * Платеж принят к обработке.
     */
    DONE("done");

    private final String code;

    BankOrderStatus(final String code) {
        this.code = code;
    }

    @Nonnull
    public String getCode() {
        return code;
    }
}
