package ru.yandex.travel.integration.balance.model.csv;

import javax.annotation.Nonnull;

/**
 * Справочник с названием валют.
 */
public enum BillingCurrency {
    /**
     * Российский рубль.
     */
    RUR("RUR"),
    /**
     * Доллар США.
     */
    USD("USD"),
    /**
     * Евро.
     */
    EUR("EUR"),
    /**
     * Белорусский рубль.
     */
    BYN("BYN"),
    /**
     * Казахстанский тенге.
     */
    KZT("KZT"),
    /**
     * Украинская гривна.
     */
    UAH("UAH"),
    /**
     * Израильский шекель.
     */
    ILS("ILS");

    private final String name;

    BillingCurrency(String name) {
        this.name = name;
    }

    @Nonnull
    public String getId() {
        return name;
    }
}
