package ru.yandex.travel.integration.balance.model.csv;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

public enum PaymentType implements ValueBasedEnum<String> {
    COST("cost"),
    REWARD("reward"),
    YANDEX_ACCOUNT_WITHDRAW("yandex_account_withdraw"),
    ;

    private final String value;

    PaymentType(String value) {
        this.value = value;
    }

    @Override
    public String getValue() {
        return value;
    }

    private static final EnumIndex<String, PaymentType> INDEX = EnumIndex.create(PaymentType.class);

    public static PaymentType forValue(String value) {
        return INDEX.getByValue(value);
    }
}
