package ru.yandex.travel.integration.balance.model.csv;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

/**
 * Тип транзакции.
 */
public enum TransactionType implements ValueBasedEnum<String> {
    /**
     * Обратный платеж для прямой транзакции. (Как для платежа так и субсидии.)
     */
    REFUND("refund"),
    /**
     * Прямая транзакция для платежа.
     */
    PAYMENT("payment"),
    ;

    private final String value;

    TransactionType(String value) {
        this.value = value;
    }

    @Override
    public String getValue() {
        return value;
    }

    private static final EnumIndex<String, TransactionType> INDEX = EnumIndex.create(TransactionType.class);

    public static TransactionType forValue(String value) {
        return INDEX.getByValue(value);
    }
}
