package ru.yandex.travel.integration.balance.xmlrpc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

import com.google.common.base.Preconditions;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientRequestImpl;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.xml.sax.XMLReader;

class XmlRpcConvertersExposer extends XmlRpcStreamTransport implements XmlRpcConverters {
    public static final int DEFAULT_REQUEST_SIZE = 1024;

    public XmlRpcConvertersExposer(XmlRpcClient client) {
        super(client);
        Preconditions.checkArgument(client.getConfig() instanceof XmlRpcStreamRequestConfig, "Unsupported config type");
    }

    private XmlRpcStreamRequestConfig getConfig() {
        return (XmlRpcStreamRequestConfig) getClient().getConfig();
    }

    @Override
    protected void close() {
        throw new UnsupportedOperationException("This class should only be used for serializers obtaining");
    }

    @Override
    protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig pConfig) {
        throw new UnsupportedOperationException("This class should only be used for serializers obtaining");
    }

    @Override
    protected void writeRequest(ReqWriter pWriter) {
        throw new UnsupportedOperationException("This class should only be used for serializers obtaining");
    }

    @Override
    protected InputStream getInputStream() {
        throw new UnsupportedOperationException("This class should only be used for serializers obtaining");
    }

    @Override
    protected XMLReader newXMLReader() {
        return XmlUtils.createXmlReader();
    }

    @Override
    public XmlRpcRequestXmlConverter getRequestConverter() {
        return (methodName, parameters) -> {
            try {
                XmlRpcRequest request = new XmlRpcClientRequestImpl(getConfig(), methodName, parameters);
                ReqWriter writer = newReqWriter(request);
                ByteArrayOutputStream out = new ByteArrayOutputStream(DEFAULT_REQUEST_SIZE);
                writer.write(out);
                return out.toString();
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public XmlRpcResponseXmlConverter getResponseConverter() {
        return response -> {
            try {
                byte[] data = response.getBytes();
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                return readResponse(getConfig(), in);
            } catch (XmlRpcException e) {
                throw new XmlRpcRuntimeException(e);
            }
        };
    }
}
