package ru.yandex.travel.integration.balance.xmlrpc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.common.TypeFactoryImpl;

public class XmlRpcHelper {
    public static XmlRpcConverters createXmlConverters() {
        XmlRpcClient client = new XmlRpcClient();
        client.setConfig(new XmlRpcClientConfigImpl());
        return new XmlRpcConvertersExposer(client);
    }

    /**
     * See {@linkplain TypeFactoryImpl} for the supported types list.
     */
    public static Object convertToBasicType(Object value) {
        if (value instanceof Long) {
            long lv = (Long) value;
            return Integer.MIN_VALUE <= lv && lv <= Integer.MAX_VALUE ? (int) lv : String.valueOf(lv);
        } else if (value instanceof List) {
            List<Object> result = new ArrayList<>();
            for (Object listValue : ((List<?>) value)) {
                result.add(convertToBasicType(listValue));
            }
            return result;
        } else if (value instanceof Map) {
            Map<Object, Object> map = new HashMap<>();
            for (Map.Entry<?, ?> entry : ((Map<?, ?>) value).entrySet()) {
                map.put(convertToBasicType(entry.getKey()), convertToBasicType(entry.getValue()));
            }
            return map;
        } else {
            return value;
        }
    }
}
