package ru.yandex.travel.integration.balance.xmlrpc;

import java.io.StringReader;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlUtils {
    public static SAXReader createSaxReader() {
        try {
            SAXReader saxReader = new SAXReader();
            // https://wiki.yandex-team.ru/security/for/web-developers/xxe/
            saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            return saxReader;
        } catch (SAXException e) {
            throw new RuntimeException("Failed to create a SAXReader", e);
        }
    }

    public static XMLReader createXmlReader() {
        try {
            return createSaxReader().getXMLReader();
        } catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document parseDocument(String xml) {
        try {
            return createSaxReader().read(new StringReader(xml));
        } catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }
}
