package ru.yandex.travel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;

public class PropertyUtils {

    public static List<Integer> stringToListOfInts(String str) {
        return stringToListOfInts(str, ",");
    }

    public static List<Integer> stringToListOfInts(String str, String regex) {
        ImmutableList.Builder<Integer> builder = ImmutableList.builder();
        if (!Strings.isNullOrEmpty(str)) {
            HashSet<Integer> uniqueIds = new HashSet<>();
            for (String clientIdStr : str.split(regex)) {
                Integer id = Integer.parseInt(clientIdStr.trim());
                uniqueIds.add(id);
            }
            builder.addAll(uniqueIds);
        }
        return builder.build();
    }

    public static ImmutableList<String> stringToListOfStrings(String str) {
        return stringToListOfStrings(str, ",");
    }

    public static ImmutableList<String> stringToListOfStrings(String str, String regex) {
        if (Strings.isNullOrEmpty(str)) {
            return ImmutableList.of();
        }
        List<String> values = new ArrayList<>();
        for (String valStr : str.split(regex)) {
            values.add(valStr.trim());
        }
        return ImmutableList.copyOf(values);
    }

    public static ImmutableMap<String, String> stringToMap(String value) {
        return stringToMap(value, ",", "=");
    }

    public static ImmutableMap<String, String> stringToMap(String value, String entriesDelimiter, String kvDelimiter) {
        ImmutableMap.Builder<String, String> mapping = ImmutableMap.builder();
        if (!Strings.isNullOrEmpty(value)) {
            for (String hostDstIdPair : value.split(entriesDelimiter)) {
                String[] hostDstId = hostDstIdPair.split(kvDelimiter);
                Preconditions.checkArgument(hostDstId.length == 2, "illegal key/value format: %s", hostDstIdPair);
                mapping.put(hostDstId[0].trim(), hostDstId[1].trim());
            }
        }
        return mapping.build();
    }
}
