package ru.yandex.travel.commons.concurrent;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ExecutorUtils {
    /**
     * Copy-pasted from the {@linkplain ExecutorService} documentation.
     */
    public static void shutdownAndAwaitTermination(ExecutorService pool, Duration shutdownTimeout) {
        long start = System.currentTimeMillis();
        pool.shutdown(); // Disable new tasks from being submitted
        try {
            // Wait a while for existing tasks to terminate
            if (!pool.awaitTermination(shutdownTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                pool.shutdownNow(); // Cancel currently executing tasks
                long millisAvailable = Math.max(shutdownTimeout.toMillis() - (System.currentTimeMillis() - start), 0);
                // Wait a while for tasks to respond to being cancelled
                if (!pool.awaitTermination(millisAvailable, TimeUnit.MILLISECONDS)) {
                    throw new RuntimeException("Pool did not terminate");
                }
            }
        } catch (InterruptedException ie) {
            // (Re-)Cancel if current thread also interrupted
            pool.shutdownNow();
            // Preserve interrupt status
            Thread.currentThread().interrupt();
        }
    }
}
