package ru.yandex.travel.commons.concurrent;

import org.slf4j.Logger;

public class PausableTerminationSemaphore extends TerminationSemaphore {
    public static final int PAUSED_MASK = (1 << 1);

    public PausableTerminationSemaphore() {
        this(null, null);
    }

    public PausableTerminationSemaphore(Logger logger, String name) {
        super(logger, name);
    }

    @Override
    protected boolean allowPermitAcquiring(int count, int flags) {
        return (!isFlagPresent(flags, PAUSED_MASK)) && super.allowPermitAcquiring(count, flags);
    }

    public void pause() {
        updateFlags(
                (flags) -> flags | PAUSED_MASK,
                (permits) -> {
                    if (logger != null) {
                        logger.info("Paused semaphore: {}. Permits active: {}", name, permits);
                    }
                }
        );
    }

    public void resume() {
        updateFlags(
                (flags) -> flags & (~PAUSED_MASK),
                (permits) -> {
                    if (logger != null) {
                        logger.info("Resuming semaphore: {}. Permits active: {}", name, permits);
                    }
                }
        );
    }

    public boolean isActive() {
        int flags = getCurrentFlags();
        return !(isFlagPresent(flags, SHUTTING_DOWN_MASK) || isFlagPresent(flags, PAUSED_MASK));
    }
}
