package ru.yandex.travel.commons.crypto;

import java.security.MessageDigest;

import com.google.common.io.BaseEncoding;
import lombok.SneakyThrows;

public class HashingUtils {
    @SneakyThrows
    public static String hashPhone(String phone) {
        String normalizedPhone =  phone.replaceAll("[^\\d]", "");
        if (normalizedPhone.startsWith("7")) {
            normalizedPhone = normalizedPhone.replaceFirst("7", "8");
        } else if (normalizedPhone.startsWith("007")) {
            normalizedPhone = normalizedPhone.replaceFirst("007", "8");
        }
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        return BaseEncoding.base64Url().encode(digest.digest(normalizedPhone.getBytes()));
    }

    @SneakyThrows
    public static String hashEmail(String email) {
        String normalizedEmail = email.toLowerCase();
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        return BaseEncoding.base64Url().encode(digest.digest(normalizedEmail.getBytes()));
    }
}
