package ru.yandex.travel.commons.datetime;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class DateTimeUtils {
    public static final DateTimeFormatter STANDARD_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static String standardFormatLocalDate(LocalDate dt) {
        return dt.format(STANDARD_DATE_FORMATTER);
    }

    public static LocalDate standardParseLocalDate(String dt) {
        return LocalDate.parse(dt, STANDARD_DATE_FORMATTER);
    }
}
