package ru.yandex.travel.commons.enums;

import java.util.concurrent.ConcurrentHashMap;

import lombok.Getter;

public class MultiEnumIndex {
    @Getter
    private static final MultiEnumIndex global = new MultiEnumIndex();

    private final ConcurrentHashMap<Class<?>, EnumIndex<?, ? extends Enum<?>>> indices = new ConcurrentHashMap<>();

    @SuppressWarnings("unchecked")
    public <K, V extends Enum<V> & ValueBasedEnum<K>> EnumIndex<K, V> get(Class<V> enumClass) {
        return (EnumIndex<K, V>) indices.computeIfAbsent(enumClass, key -> EnumIndex.create(enumClass));
    }

    public static <K, V extends Enum<V> & ValueBasedEnum<K>> EnumIndex<K, V> getGlobal(Class<V> enumClass) {
        return getGlobal().get(enumClass);
    }
}
