package ru.yandex.travel.commons.experiments;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.travel.proto.BaseTypes;

public class KVExperiments {
    public static List<BaseTypes.TStringPair> toProto(Map<String, String> experiments) {
        return experiments.entrySet().stream().map(entry ->
                        BaseTypes.TStringPair.newBuilder()
                                .setKey(entry.getKey())
                                .setValue(entry.getValue())
                                .build())
                .collect(Collectors.toList());
    }

    public static Map<String, String> fromProto(List<BaseTypes.TStringPair> protoExperiments) {
        return protoExperiments.stream()
                .collect(Collectors.toMap(BaseTypes.TStringPair::getKey, BaseTypes.TStringPair::getValue));
    }
}
