package ru.yandex.travel.commons.experiments;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * Defines all the UaaS experiments active for the order.
 * The default values of this class's fields should correspond to
 * "disabled" state, so the object created with its default constructor
 * should correspond to "no experiments at all".
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Getter
@Setter
@NoArgsConstructor
@EqualsAndHashCode
public class OrderExperiments {

    @ExperimentFlag("HOTELS_deferred_payments_linked_card")
    private boolean automaticDeferredCharge;

    @ExperimentFlag("HOTELS_strike_through_discount")
    private boolean strikeThroughPrices;

    @ExperimentFlag("AVIA_refresh_aeroflot_order_state")
    private boolean refreshAeroflotOrderState;

    @ExperimentFlag("HOTELS_trustnewform")
    private boolean newCommonPaymentWebForm;
}
