package ru.yandex.travel.commons.experiments;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * Defines UaaS experiments active for current portal search session (suggest, search page, hotels page etc).
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Getter
@Setter
@NoArgsConstructor
@EqualsAndHashCode
public class UaasSearchExperiments {
    @ExperimentFlag("HOTELS_geofeatures")
    private boolean hotelsGeofeatures;

    @ExperimentFlag("HOTELS_idealsearch")
    private boolean hotelsSearchViaGeoCounter;

    @ExperimentFlag("HOTELS_leftfilters_prod")
    private boolean leftFilters;

    @ExperimentFlag("HOTELS_oldproduction")
    private boolean searchFormOldProduction;

    @ExperimentFlag("HOTELS_oldproductionround")
    private boolean searchFormOldProductionRound;

    @ExperimentFlag("HOTELS_imagesnowatermark")
    private boolean hotelImagesNoWatermark;

    @ExperimentFlag("HOTELS_strike_through_discount")
    private boolean strikeThroughPrices;

    @ExperimentFlag("HOTELS_rooms_matching")
    private boolean catRoomForAll;

    @ExperimentFlag("HOTELS_booking_land_searchpage")
    private boolean bookingLandSearchPage;

    @ExperimentFlag("HOTELS_booking_land_hotelpage")
    private boolean bookingLandHotelPage;

    @ExperimentFlag("HOTELS_rankingnew")
    private boolean newRanking;

    @ExperimentFlag("HOTELS_ranking_personal")
    private boolean personalRanking;

    @ExperimentFlag("HOTELS_ostrovok_clickout_off_touch")
    private boolean ostrovokClickoutTouchDisabled;

    @ExperimentFlag("HOTELS_ostrovok_clickout_off")
    private boolean ostrovokClickoutDisabled;

    @ExperimentFlag("HOTELS_ranking_exploration")
    private String rankingExploration;

    @ExperimentFlag("HOTELS_moskowarea")
    private boolean moskowAreaEnabled;

    @ExperimentFlag("HOTELS_online_ranking")
    private String onlineRanking;
}
