package ru.yandex.travel.commons.grpc;

import java.util.UUID;

import ru.yandex.travel.commons.proto.EErrorCode;
import ru.yandex.travel.commons.proto.Error;

public class CommonProtoChecks {
    private CommonProtoChecks() {
    }


    public static UUID checkStringIsUuid(String field, String value) {
        try {
            return UUID.fromString(value);
        } catch (IllegalArgumentException e) {
            throw Error.with(EErrorCode.EC_INVALID_ARGUMENT, "Value of %s (%s) is not a UUID", field, value).toEx();
        }
    }
}
