package ru.yandex.travel.commons.health;

import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface HealthChecked {
    /**
     * Returns a value indicating whether the service is considered healthy or not.
     * The implementation should be thread-safe as it is used as a data-source for a gauge
     *
     * @return {@code true} if the service is healthy or {@code false otherwise
     */
    boolean isHealthy();
}
