package ru.yandex.travel.commons.health;

import java.util.concurrent.CompletableFuture;

import javax.validation.constraints.NotNull;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Metrics;

public class HealthCheckedSupplier<T extends HealthChecked> {
    private final T wrapped;
    private final String name;
    private final Counter unhealthyInvocationCounter;


    public HealthCheckedSupplier(@NotNull T wrapped, @NotNull String name) {
        this.wrapped = wrapped;
        this.name = name;
        this.unhealthyInvocationCounter =
                Counter.builder("health.unhealthyInvocation").tag("component", name).register(Metrics.globalRegistry);
        Gauge.builder("health.state", () -> wrapped.isHealthy() ? 1 : 0).tag("component", name).register(Metrics.globalRegistry);
    }

    public CompletableFuture<T> get() {
        if (wrapped.isHealthy()) {
            return CompletableFuture.completedFuture(wrapped);
        } else {
            unhealthyInvocationCounter.increment();
            return CompletableFuture.failedFuture(new UnhealthyServiceException(name));
        }
    }
}
