package ru.yandex.travel.commons.http.apiclient;

import java.util.concurrent.CompletableFuture;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import lombok.extern.slf4j.Slf4j;
import org.asynchttpclient.Response;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;

// todo(tlg-13) The base implementation is copied from DefaultTrustClient & AviaApiProxy, we need to merge these classes to get rid of duplicate code
@Slf4j
public class HttpApiClientBase extends AsyncHttpClientBase {

    private final ObjectMapper objectMapper;

    public HttpApiClientBase(
            AsyncHttpClientWrapper asyncHttpClient,
            HttpApiPropertiesBase config,
            ObjectMapper objectMapper
    ) {
        super(asyncHttpClient, config);
        this.objectMapper = objectMapper;
    }

    protected <RQ, RS> CompletableFuture<RS> sendRequest(String method, String path, RQ body, Class<RS> responseType, String purpose) {
        return super.sendRequest(
                HttpMethod.valueOf(method),
                path,
                body,
                this::serializeRequest,
                (Response response) -> this.parseSuccessfulContent(response, responseType),
                purpose
        );
    }

    protected <T> String serializeRequest(T request) throws JsonProcessingException {
        if (request == null) {
            return null;
        } else {
            return objectMapper.writeValueAsString(request);
        }
    }

    protected <T> T parseSuccessfulContent(Response response, Class<T> contentType) throws Exception {
        final String responseBody = response.getResponseBody();
        if (Strings.isNullOrEmpty(responseBody) || contentType == null) {
            return null;
        } else {
            return objectMapper.readValue(responseBody, contentType);
        }
    }
}
