package ru.yandex.travel.commons.http.apiclient;

import lombok.Getter;

@Getter
public class HttpApiException extends RuntimeException {
    private Integer statusCode;
    private Object content;

    public HttpApiException(String message, Throwable cause, Integer statusCode, Object content) {
        super(message, cause);
        this.statusCode = statusCode;
        this.content = content;
    }

    public HttpApiException(String message, Integer statusCode, Object content) {
        this(message, null, statusCode, content);
    }

    public HttpApiException(Throwable cause, Integer statusCode, Object content) {
        this(null, cause, statusCode, content);
    }
}
