package ru.yandex.travel.commons.http.apiclient;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(builderMethodName = "basePropertiesBuilder")
public class HttpApiPropertiesBase {
    @NotEmpty
    private String baseUrl;
    @NotNull
    private Duration httpReadTimeout;
    @NotNull
    private Duration httpRequestTimeout;
}
