package ru.yandex.travel.commons.http.apiclient;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;

import ru.yandex.travel.commons.retry.RetryStrategy;

public class HttpApiRetryStrategy<RS> implements RetryStrategy<RS> {
    public static final Duration DEFAULT_WAIT_DURATION = Duration.ofSeconds(1);
    public static final int DEFAULT_NUM_RETRIES = 5;
    public static final List<Class<? extends Exception>> DEFAULT_RETRYABLE_EXCEPTIONS = Arrays.asList(
            TimeoutException.class,
            IOException.class,
            HttpApiRetryableException.class
    );

    private final Duration waitDuration;
    private final int numRetries;
    private final List<Class<? extends Exception>> retryableExceptions;

    public HttpApiRetryStrategy() {
        this(DEFAULT_WAIT_DURATION, DEFAULT_NUM_RETRIES, DEFAULT_RETRYABLE_EXCEPTIONS);
    }

    public HttpApiRetryStrategy(Duration waitDuration, int numRetries,
                                List<Class<? extends Exception>> retryableExceptions) {
        this.waitDuration = waitDuration;
        this.numRetries = numRetries;
        this.retryableExceptions = retryableExceptions;
    }

    @Override
    public boolean shouldRetryOnException(Exception ex) {
        for (Class<? extends Exception> exceptionClass : this.retryableExceptions) {
            if (exceptionClass.isInstance(ex)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void validateResult(RS result) {}

    @Override
    public Duration getWaitDuration(int iteration, Exception ex, RS result) {
        return waitDuration;
    }

    @Override
    public int getNumRetries() {
        return numRetries;
    }
}
