package ru.yandex.travel.commons.http.apiclient;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class HttpApiWithTvmPropertiesBase extends HttpApiPropertiesBase {
    @NotNull
    private Boolean tvmEnabled;
    @NotEmpty
    private String tvmDestinationAlias;

    @Builder(builderMethodName = "baseTvmPropertiesBuilder")
    public HttpApiWithTvmPropertiesBase(String baseUrl, Duration httpReadTimeout, Duration httpRequestTimeout,
                                        Boolean tvmEnabled, String tvmDestinationAlias) {
        super(baseUrl, httpReadTimeout, httpRequestTimeout);
        this.tvmEnabled = tvmEnabled;
        this.tvmDestinationAlias = tvmDestinationAlias;
    }
}
