package ru.yandex.travel.commons.jackson;

import com.fasterxml.jackson.databind.util.StdConverter;

public class BooleanConverters {
    public static class ToString extends StdConverter<Boolean, String> {
        @Override
        public String convert(Boolean value) {
            return String.valueOf(value);
        }
    }

    public static class FromString extends StdConverter<String, Boolean> {
        @Override
        public Boolean convert(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "true":
                    return Boolean.TRUE;
                case "false":
                    return Boolean.FALSE;
                default:
                    throw new IllegalArgumentException("Unsupported boolean value: " + value);
            }
        }
    }
}
