package ru.yandex.travel.commons.jackson;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

import com.fasterxml.jackson.databind.util.StdConverter;
import com.google.common.base.Preconditions;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.MultiEnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

public abstract class ValueBasedEnumDeserializationConverter<K, V extends Enum<V> & ValueBasedEnum<K>> extends StdConverter<K, V> {
    private final EnumIndex<K, V> index;

    @SuppressWarnings("unchecked")
    protected ValueBasedEnumDeserializationConverter() {
        ParameterizedType parametrizedClass = (ParameterizedType) getClass().getGenericSuperclass();
        Class<?> parentClass = (Class<?>) parametrizedClass.getRawType();
        Preconditions.checkArgument(parentClass.equals(ValueBasedEnumDeserializationConverter.class),
                "Unexpected class hierarchy of %s; actual parent %s", getClass().getName(), parentClass.getName());
        Type[] parameters = parametrizedClass.getActualTypeArguments();
        Preconditions.checkArgument(parameters.length == 2,
                "Unexpected template parameters: %s", List.of(parameters));
        Class<V> enumType = (Class<V>) parameters[1];
        index = MultiEnumIndex.getGlobal().get(enumType);
    }

    @Override
    public V convert(K value) {
        return index.getByValue(value);
    }
}
