package ru.yandex.travel.commons.lang;

public class ComparatorUtils {
    /**
     * Returns true is the first argument ('a') is less than the second one ('b').
     */
    public static <T extends Comparable<? super T>> boolean isLessThan(T a, T b) {
        return a.compareTo(b) < 0;
    }

    public static <T extends Comparable<? super T>> boolean isEqualByCompareTo(T a, T b) {
        return a.compareTo(b) == 0;
    }

    public static <T extends Comparable<? super T>> T min(T a, T b) {
        return isLessThan(a, b) ? a : b;
    }

    public static <T extends Comparable<? super T>> T max(T a, T b) {
        return !isLessThan(a, b) ? a : b;
    }

    public static <T extends Comparable<? super T>> T limit(T min, T value, T max) {
        return isLessThan(value, min) ? min : isLessThan(max, value) ? max : value;
    }
}
