package ru.yandex.travel.commons.lang;

import java.math.BigDecimal;
import java.math.RoundingMode;

import org.javamoney.moneta.Money;

public class MoneyUtils {
    public static final int MAX_INTEGER_MONEY_SCALE = 0;
    public static final int MAX_DECIMAL_MONEY_SCALE = 2;

    public static Money safeAdd(Money a, Money b) {
        return a == null ? b : b == null ? a : a.add(b);
    }

    public static void ensureIntegerScale(Money money) {
        ensureIntegerScale(money.getNumberStripped());
    }

    public static void ensureIntegerScale(BigDecimal money) {
        if (money.scale() > MAX_INTEGER_MONEY_SCALE) {
            throw new IllegalStateException("Unexpected decimal money value: " + money);
        }
    }

    public static Money roundDownToInteger(Money money) {
        return roundToInteger(money, RoundingMode.FLOOR);
    }

    public static Money roundUpToInteger(Money money) {
        return roundToInteger(money, RoundingMode.CEILING);
    }

    public static Money roundToInteger(Money money, RoundingMode mode) {
        return roundToScale(money, MAX_INTEGER_MONEY_SCALE, mode);
    }

    public static Money roundToScale(Money money, int scale, RoundingMode mode) {
        BigDecimal value = money.getNumberStripped();
        if (value.scale() <= scale) {
            return money;
        } else {
            value = value.setScale(scale, mode);
            return Money.of(value, money.getCurrency());
        }
    }

    public static Money roundToDecimal(Money money, RoundingMode mode) {
        return roundToScale(money, MAX_DECIMAL_MONEY_SCALE, mode);
    }

    public static void ensureDecimalScale(Money money) {
        ensureDecimalScale(money.getNumberStripped());
    }

    public static void ensureDecimalScale(BigDecimal money) {
        if (money.scale() > MAX_DECIMAL_MONEY_SCALE) {
            throw new IllegalStateException("Unexpected decimal money value part: " + money);
        }
    }
}
