package ru.yandex.travel.commons.logging;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;

import ru.yandex.travel.commons.logging.masking.LogAwareRequestBuilder;

public interface IAsyncHttpClientWrapper {
    String DEFAULT_METHOD = "unknown";

    /**
     * @deprecated this method can't properly mask personal data, if there isn't any personal or binary data in response.
     */
    @Deprecated
    CompletableFuture<Response> executeRequest(RequestBuilder requestBuilder, String method, String requestId);

    <T> CompletableFuture<T> executeRequest(LogAwareRequestBuilder requestBuilder, String method, String requestId,
                                            ResponseParser<T> responseParser);

    default <T> CompletableFuture<T> executeRequest(LogAwareRequestBuilder requestBuilder, String method, String requestId,
                                                    ResponseBodyParser<T> responseBodyParser) {
        return executeRequest(requestBuilder, method, requestId,
                (Response response) -> responseBodyParser.parse(response.getResponseBody()));
    }

    @Deprecated
    default CompletableFuture<Response> executeRequest(RequestBuilder requestBuilder, String method) {
        return executeRequest(requestBuilder, method, null);
    }

    @Deprecated
    default CompletableFuture<Response> executeRequest(RequestBuilder requestBuilder) {
        return executeRequest(requestBuilder, DEFAULT_METHOD);
    }


    @FunctionalInterface
    interface ResponseParser<T> {
        T parse(Response response);
    }

    @FunctionalInterface
    interface ResponseBodyParser<T> {
        T parse(String s);
    }

    @FunctionalInterface
    interface BodySerializer<T> {
        byte[] serialize(T bodyObject) throws IOException;
    }
}
