package ru.yandex.travel.commons.logging;

import java.time.LocalDateTime;
import java.util.Map;

import lombok.Data;

@Data
public class LogEventRequest {
    private Long timestamp;
    private LocalDateTime dateTime;
    private String eventKind = LogEventType.REQUEST.getValue();
    private String destinationName;
    private String destinationMethod;
    private String callId;
    private String fqdn;
    private String requestUrl;
    private Integer requestSize;
    private String requestMethod;
    private Map<String, String> requestHeaders;
    private Map<String, String> mdc;
    private Object requestBody;
}
