package ru.yandex.travel.commons.logging;

import java.time.LocalDateTime;
import java.util.Map;

import lombok.Data;

@Data
public class LogEventResponse {
    private Long timestamp;
    private LocalDateTime dateTime;
    private String eventKind = LogEventType.RESPONSE.getValue();
    private String destinationName;
    private String destinationMethod;
    private String callId;
    private String fqdn;
    private Long responseTime;
    private Integer responseSize;
    private Integer responseCode;
    private Map<String, String> responseHeaders;
    private Map<String, String> mdc;
    private Object responseBody;
    private String exceptionClass;
    private Throwable exception;
}
