package ru.yandex.travel.commons.logging;

import java.util.Iterator;
import java.util.Map;

import io.opentracing.propagation.TextMap;
import org.asynchttpclient.RequestBuilder;

public class RequestBuilderInjectAdapter implements TextMap {
    private final RequestBuilder requestBuilder;

    public RequestBuilderInjectAdapter(RequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        throw new UnsupportedOperationException("Should be used only with tracer#inject()");
    }

    @Override
    public void put(String key, String value) {
        this.requestBuilder.addHeader(key, value);
    }
}
