package ru.yandex.travel.commons.logging;

import java.nio.charset.Charset;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.extern.slf4j.Slf4j;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.util.Strings;

@Plugin(name = "SlackMessageLayout", category = Node.CATEGORY, elementType = Layout.ELEMENT_TYPE, printObject = true)
@Slf4j
public class SlackMessageLayout extends AbstractStringLayout {

    private final ObjectMapper objectMapper;
    private final ObjectWriter writer;

    protected SlackMessageLayout(Charset charset) {
        super(charset);
        objectMapper = new ObjectMapper();
        writer = objectMapper.writer();
    }

    @PluginFactory
    public static SlackMessageLayout createLayout() {
        return new SlackMessageLayout(Charset.forName("UTF-8"));
    }

    @Override
    public String toSerializable(LogEvent event) {
        ObjectNode node = objectMapper.createObjectNode()
                .put("text", "```" + event.getMessage().getFormattedMessage() + "```");

        try {
            return writer.writeValueAsString(node);
        } catch (JsonProcessingException e) {
            log.error("An error occurred processing json", e);
            return Strings.EMPTY; // as done in other appenders
        }
    }
}
