package ru.yandex.travel.commons.logging.http;


import java.util.EnumMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import com.google.common.collect.ImmutableMap;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import lombok.Getter;

import ru.yandex.travel.commons.metrics.MetricsUtils;

@Getter
public class Meters {
    private final Counter errorCounter;
    private final ConcurrentMap<String, Counter> errorWithExceptionCounters;
    private final ImmutableMap<HttpStatus, Counter> callCounters;
    private final ImmutableMap<HttpStatus, Counter> responseByteCounters;
    private final Timer callTimer2xx;

    public Meters(String destination, String method) {
        errorCounter = Counter.builder("http.client.errors")
                .tag("destination", destination)
                .tag("method", method)
                .register(Metrics.globalRegistry);
        errorWithExceptionCounters = new ConcurrentHashMap<>();
        EnumMap<HttpStatus, Counter> callCountersBuilder = new EnumMap<>(HttpStatus.class);
        EnumMap<HttpStatus, Counter> responseByteCountersBuilder = new EnumMap<>(HttpStatus.class);
        EnumMap<HttpStatus, Timer> callTimersBuilder = new EnumMap<>(HttpStatus.class);
        for (HttpStatus status : HttpStatus.values()) {
            String statusName = status.toString();
            Counter httpCallCounter = Counter.builder("http.client.calls.count")
                    .tag("destination", destination)
                    .tag("method", method)
                    .tag("status", statusName)
                    .register(Metrics.globalRegistry);
            callCountersBuilder.put(status, httpCallCounter);
            Counter httpResponseByteCounter = Counter.builder("http.client.responses.bytes")
                    .tag("destination", destination)
                    .tag("method", method)
                    .tag("status", statusName)
                    .register(Metrics.globalRegistry);
            responseByteCountersBuilder.put(status, httpResponseByteCounter);
        }
        this.callCounters = ImmutableMap.copyOf(callCountersBuilder);
        this.responseByteCounters = ImmutableMap.copyOf(responseByteCountersBuilder);

        this.callTimer2xx = Timer.builder("http.client.calls.time")
                .tag("destination", destination)
                .tag("method", method)
                .tag("status", HttpStatus.CODE_2XX.toString())
                .serviceLevelObjectives(MetricsUtils.smallDurationSla())
                .publishPercentiles(MetricsUtils.higherPercentiles())
                .register(Metrics.globalRegistry);
    }
}
