package ru.yandex.travel.commons.logging.http;

import io.netty.handler.codec.http.HttpMethod;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Value;

@Value
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class MethodMetaData {
    String destinationMethod;
    String path;
    Class<?> responseType;
    HttpMethod httpMethod;

    public static MethodMetaData of(String destinationMethod,
                                    String path,
                                    Class<?> responseType,
                                    HttpMethod httpMethod) {
        return new MethodMetaData(destinationMethod, path, responseType, httpMethod);
    }

    public static MethodMetaData getFor(String destinationMethod, String path, Class<?> responseType) {
        return new MethodMetaData(destinationMethod, path, responseType, HttpMethod.GET);
    }

    public static MethodMetaData postFor(String destinationMethod, String path, Class<?> responseType) {
        return new MethodMetaData(destinationMethod, path, responseType, HttpMethod.POST);
    }
}
