package ru.yandex.travel.commons.logging.http;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder
public class ServiceMetaData {
    String baseUrl;
    @Singular
    List<MethodMetaData> methods;

    public Set<String> getMethodNames() {
        return methods.stream()
                .map(MethodMetaData::getDestinationMethod)
                .collect(Collectors.toSet());
    }

    public MethodMetaData getMethod(String methodName) {
        return methods.stream()
                .filter(method -> methodName.equals(method.getDestinationMethod()))
                .findFirst()
                .orElseThrow();
    }

    public String getUrl(String method) {
        return getBaseUrl() + getMethod(method).getPath();
    }
}
