package ru.yandex.travel.commons.logging.masking;

import java.util.function.Supplier;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.ByteArrayBodyGenerator;

@Slf4j
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class LogAwareBodyGenerator implements BodyGenerator {
    private final Object object;
    private final Supplier<Body> bodySupplier;

    public static LogAwareBodyGenerator of(Object object, ObjectMapper bodyObjectMapper) {
        return LogAwareBodyGenerator.of(object, () -> {
            try {
                return bodyObjectMapper.writeValueAsBytes(object);
            } catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static LogAwareBodyGenerator of(Object object, Supplier<byte[]> bodyGenerator) {
        return new LogAwareBodyGenerator(object,
                () -> new ByteArrayBodyGenerator(
                        bodyGenerator.get()
                ).createBody());
    }

    @SneakyThrows
    @Override
    public Body createBody() {
        return bodySupplier.get();
    }

    public String getContentForLogs() {
        try {
            return LogMaskingConverter.getObjectMapperForLogEvents().writeValueAsString(object);
        } catch (JsonProcessingException e) {
            log.error("Error serializing request", e);
            throw new RuntimeException(e);
        }
    }
}
