package ru.yandex.travel.commons.logging.masking;

import java.util.ArrayList;
import java.util.function.Supplier;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.asynchttpclient.Param;
import org.asynchttpclient.RequestBuilder;

public class LogAwareRequestBuilder extends RequestBuilder {

    /**
     * similar to {@link #addFormParam(String, String)}
     */
    public LogAwareRequestBuilder addFormParam(FormParam formParam) {
        resetNonMultipartData();
        resetMultipartData();
        if (this.formParams == null) {
            this.formParams = new ArrayList<>(1);
        }
        this.formParams.add(formParam);
        return this;
    }

    public static class FormParam extends Param {

        private final Supplier<String> valueSupplier;
        private final Supplier<String> logValueSupplier;

        private FormParam(String name, Supplier<String> valueSupplier,
                          Supplier<String> logValueSupplier) {
            super(name, null);
            this.valueSupplier = valueSupplier;
            this.logValueSupplier = logValueSupplier;
        }

        public String getValue() {
            return valueSupplier.get();
        }

        public String getValueForLogs() {
            return logValueSupplier.get();
        }

        public static <T> FormParam forObject(String name, T value, ObjectMapper objectMapper) {
            return new FormParam(name, () -> {
                try {
                    return objectMapper.writeValueAsString(value);
                } catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }, () -> {
                try {
                    return LogMaskingConverter.getObjectMapperForLogEvents().writeValueAsString(value);
                } catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        public static FormParam of(String name, String value) {
            return new FormParam(name, () -> value, () -> value);
        }
    }

}
