package ru.yandex.travel.commons.logging.masking;

import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.util.StdConverter;
import lombok.EqualsAndHashCode;
import lombok.Value;

public class MaskingJacksonAnnotationIntrospector extends JacksonAnnotationIntrospector {
    @Override
    public Object findSerializationConverter(Annotated a) {
        var personalAnn = _findAnnotation(a, PersonalData.class);
        if (personalAnn != null) {
            return ConstantStringDataConverter.of(personalAnn.value());
        }
        var binaryAnn = _findAnnotation(a, BinaryData.class);
        if (binaryAnn != null) {
            return ConstantStringDataConverter.BINARY;
        }
        return super.findSerializationConverter(a);
    }

    @EqualsAndHashCode(callSuper = true)
    @Value
    public static class ConstantStringDataConverter extends StdConverter<Object, String> {
        public static final String DEFAULT_STRING = "**REMOVED**";
        static ConstantStringDataConverter DEFAULT = new ConstantStringDataConverter(DEFAULT_STRING);
        /**
         * @implNote binary data can be anticipated as base64 string or anything else, so we just use empty string
         */
        static ConstantStringDataConverter BINARY = new ConstantStringDataConverter("");

        String value;

        @Override
        public String convert(Object ignore) {
            return value;
        }

        public static ConstantStringDataConverter of(String value) {
            if (DEFAULT_STRING.equals(value)) {
                return DEFAULT;
            }
            return new ConstantStringDataConverter(value);
        }
    }
}
