package ru.yandex.travel.commons.map;

import java.util.Map;
import java.util.NoSuchElementException;

public class MappingUtils {
    public static <K, V> V getMappingOrThrow(Map<K, V> mapping, K key) {
        V value = mapping.get(key);
        if (value == null) {
            throw new NoSuchElementException(
                    "No value mapping for key " + key + " of class " + key.getClass().getName());
        }
        return value;
    }
}
