package ru.yandex.travel.commons.messaging;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;

import com.google.protobuf.Message;

public abstract class AbstractMessageBusAndKeyValueStorage implements MessageBus, KeyValueStorage {
    @Override
    public CompletableFuture<Void> send(Message message, Duration lifetime) {
        return send(Envelope.create(message, getCompressionSettings(), null, lifetime));
    }

    @Override
    public CompletableFuture<Void> put(String key, Message message, Duration lifetime) {
        return send(Envelope.create(message, getCompressionSettings(), key, lifetime));
    }

    public abstract CompletableFuture<Void> send(Envelope envelope);

    public abstract CompressionSettings getCompressionSettings();
}
