package ru.yandex.travel.commons.messaging;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;

import com.google.protobuf.Message;

import ru.yandex.travel.commons.health.HealthChecked;

public interface KeyValueStorage extends HealthChecked {
    CompletableFuture<Void> put(String key, Message message, Duration lifetime);
    <T extends Message> CompletableFuture<T> get(String key, Class<? extends T> messageClass);

    boolean isHealthy();
    void close();
}
