package ru.yandex.travel.commons.metrics;

import java.time.Duration;

public class MetricsUtils {
    private static final Duration[] SMALL_DURATION_SLA = {
            Duration.ofMillis(1), Duration.ofMillis(10), Duration.ofMillis(100),
            Duration.ofMillis(1000), Duration.ofMillis(10000), Duration.ofMillis(100000),
    };

    private static final Duration[] SMALL_DURATION_SLA_EXTENDED = {
            Duration.ofMillis(1), Duration.ofMillis(10), Duration.ofMillis(100),
            Duration.ofMillis(300), Duration.ofMillis(800), Duration.ofMillis(1000),
            Duration.ofMillis(3000), Duration.ofMillis(5000), Duration.ofMillis(8000),
            Duration.ofMillis(10000), Duration.ofMillis(100000),
    };

    private static final Duration[] MEDIUM_DURATION_SLA = {
            Duration.ofMillis(100), Duration.ofMillis(200), Duration.ofMillis(300), Duration.ofMillis(400), Duration.ofMillis(500),
            Duration.ofSeconds(1), Duration.ofSeconds(2), Duration.ofSeconds(3), Duration.ofSeconds(4), Duration.ofSeconds(5),
            Duration.ofSeconds(10), Duration.ofSeconds(15), Duration.ofSeconds(30), Duration.ofSeconds(60),
    };

    private static final double[] COUNT_SLA = {
            1, 2, 3, 4, 5, 10, 100, 1000
    };

    private static final double[] IQR_PERCENTILES = {
            0.00, 0.10, 0.25, 0.50, 0.75, 0.90, 1.00,
    };

    private static final double[] HIGHER_PERCENTILES = {
            0.50, 0.90, 0.95, 0.99, 1.00
    };

    public static Duration[] smallDurationSla() {
        return SMALL_DURATION_SLA;
    }

    public static Duration[] smallDurationSlaExtended() {
        return SMALL_DURATION_SLA_EXTENDED;
    }

    public static Duration[] mediumDurationSla() {
        return MEDIUM_DURATION_SLA;
    }

    public static double[] countSla() {
        return COUNT_SLA;
    }

    public static double[] iqrPercentiles() {
        return IQR_PERCENTILES;
    }

    public static double[] higherPercentiles() {
        return HIGHER_PERCENTILES;
    }
}

