package ru.yandex.travel.commons.network;

import java.net.InetAddress;
import java.net.UnknownHostException;

import com.google.common.base.Preconditions;

public class NetworkUtils {
    public static String getLocalHostName() {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        } catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return Preconditions.checkNotNull(hostName, "Host name must be not null");
    }
}
