package ru.yandex.travel.commons.proto;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;

public class ProtoJsonConverter {
    public static final JsonFormat.Printer jsonPrinter = JsonFormat.printer()
            .omittingInsignificantWhitespace();
    public static final JsonFormat.Printer jsonPrinterWithDefaults = JsonFormat.printer()
            .omittingInsignificantWhitespace()
            .includingDefaultValueFields();

    public static String toJson(MessageOrBuilder message) {
        try {
            return jsonPrinter.print(message);
        } catch (InvalidProtocolBufferException e) {
            String messageType = message != null ? message.getClass().getName() : null;
            throw new RuntimeException("Failed to convert convert the " + messageType + " message to json", e);
        }
    }
}
