package ru.yandex.travel.commons.retry;

import java.time.Duration;

import org.asynchttpclient.Response;

import ru.yandex.misc.io.http.HttpStatus;

public class AhcHttpRetryStrategy extends BaseRetryStrategy<Response> {
    public AhcHttpRetryStrategy() {
        super(DEFAULT_WAIT_DURATION, DEFAULT_NUM_RETRIES);
    }

    public AhcHttpRetryStrategy(Duration waitDuration, int numRetries) {
        super(waitDuration, numRetries);
    }

    @Override
    public void validateResult(Response result) {
        if (HttpStatus.is5xx(result.getStatusCode()) && result.getStatusCode() != HttpStatus.SC_501_NOT_IMPLEMENTED) {
            throw new RuntimeException(String.format("Status code is %s", result.getStatusCode()));
        }
    }

}
