package ru.yandex.travel.commons.retry;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;

import ru.yandex.travel.commons.http.apiclient.HttpApiRetryableException;

public class BaseRetryStrategy<T> implements RetryStrategy<T> {
    public static final Duration DEFAULT_WAIT_DURATION = Duration.ofSeconds(1);
    public static final int DEFAULT_NUM_RETRIES = 5;

    private static final List<Class<? extends Exception>> RETRYABLE_EXCEPTIONS = Arrays.asList(
            TimeoutException.class,
            IOException.class,
            HttpApiRetryableException.class
    );

    private final Duration waitDuration;
    private final int numRetries;

    public BaseRetryStrategy() {
        this(DEFAULT_WAIT_DURATION, DEFAULT_NUM_RETRIES);
    }

    public BaseRetryStrategy(Duration waitDuration, int numRetries) {
        this.waitDuration = waitDuration;
        this.numRetries = numRetries;
    }

    @Override
    public boolean shouldRetryOnException(Exception ex) {
        for (Class<? extends Exception> exceptionClass : RETRYABLE_EXCEPTIONS) {
            if (exceptionClass.isInstance(ex)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void validateResult(T result) {
    }

    @Override
    public Duration getWaitDuration(int iteration, Exception ex, T result) {
        return waitDuration;
    }

    @Override
    public int getNumRetries() {
        return numRetries;
    }
}
