package ru.yandex.travel.commons.retry;

import java.time.Duration;

public class DefaultRetryStrategy<T> implements RetryStrategy<T> {
    @Override
    public boolean shouldRetryOnException(Exception ex) {
        return true;
    }

    @Override
    public void validateResult(T result) {
    }

    @Override
    public Duration getWaitDuration(int iteration, Exception ex, T result) {
        return Duration.ZERO;
    }

    @Override
    public int getNumRetries() {
        return Integer.MAX_VALUE;
    }
}
