package ru.yandex.travel.commons.retry;

import java.util.concurrent.ThreadLocalRandom;

import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public class RetryRateLimiter {
    void onSuccess() {
        updateFailureRate(0);
    }

    void onFailure() {
        updateFailureRate(1);
    }

    synchronized boolean shouldRetry() {
        return ThreadLocalRandom.current().nextDouble() < (retryRate / (expDecayingFailureRate + 0.001));
    }

    synchronized private void updateFailureRate(double failure) {
        expDecayingFailureRate = expDecayingFailureRate * expDecayConstant + failure * (1.0 - expDecayConstant);
    }

    private double expDecayingFailureRate = 0;

    private final double retryRate;
    private static final double expDecayConstant = 0.99;
}
