package ru.yandex.travel.commons.retry;

import java.time.Duration;

public interface RetryStrategy<T> {
    boolean shouldRetryOnException(Exception ex);

    void validateResult(T result);// Retry if anything is thrown

    Duration getWaitDuration(int iteration, Exception ex, T result);

    int getNumRetries();
}
